/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.zb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZPLUtilities {
    public static final int ZPL_INTERNAL_FORMAT_PREFIX_CHAR = 30;
    public static final int ZPL_INTERNAL_COMMAND_PREFIX_CHAR = 16;
    public static final int ZPL_INTERNAL_DELIMITER_CHAR = 31;
    public static final String ZPL_INTERNAL_FORMAT_PREFIX = new String(new byte[]{30});
    public static final String ZPL_INTERNAL_COMMAND_PREFIX = new String(new byte[]{16});
    public static final String ZPL_INTERNAL_DELIMITER = new String(new byte[]{31});
    public static final String PRINTER_INFO = new String(new byte[]{16, 72, 73});
    public static final String PRINTER_STATUS = new String(new byte[]{16, 72, 83});
    public static final String PRINTER_CONFIG_LABEL = new String(new byte[]{16, 87, 67});
    public static final String PRINTER_DIRECTORY_LABEL = new String(new byte[]{30, 88, 65, 30, 87, 68, 42, 58, 42, 46, 42, 30, 88, 90});
    public static final String PRINTER_NETWORK_CONFIG_LABEL = new String(new byte[]{16, 87, 76});
    public static final String PRINTER_CALIBRATE = new String(new byte[]{16, 74, 67});
    public static final String PRINTER_RESET = new String(new byte[]{16, 74, 82});
    public static final String PRINTER_RESET_NETWORK = new String(new byte[]{16, 87, 82});
    public static final String PRINTER_RESTORE_DEFAULTS = new String(new byte[]{30, 88, 65, 30, 74, 85, 70, 30, 88, 90});
    public static final String PRINTER_GET_SUPER_HOST_STATUS = new String(new byte[]{30, 88, 65, 30, 72, 90, 65, 30, 88, 90});
    public static final String PRINTER_GET_STORAGE_INFO_COMMAND = new String(new byte[]{30, 88, 65, 30, 72, 87, 42, 58, 88, 88, 88, 88, 46, 81, 81, 81, 30, 88, 90});
    public static final String FILE_DRIVE_INFO_SETTING_NAME = "file.drive_info";
    public static final String FILE_DRIVE_LISTING_SETTING_NAME = "file.drive_listing";

    public static String decorateWithCommandPrefix(String var0) {
        if (var0 == null) {
            return null;
        }
        return var0.indexOf("~") != -1 ? var0.replace('~', '\u0010') : ZPL_INTERNAL_COMMAND_PREFIX + var0;
    }

    public static String decorateWithFormatPrefix(String var0) {
        if (var0 == null) {
            return null;
        }
        return var0.indexOf("^") != -1 ? var0.replace('^', '\u001e') : ZPL_INTERNAL_FORMAT_PREFIX + var0;
    }

    public static String replaceAllWithInternalDelimeter(String var0) {
        return var0 == null ? null : var0.replaceAll(",", ZPL_INTERNAL_DELIMITER);
    }

    public static String replaceAllWithInternalCharacters(String var0) {
        return var0 == null ? null : ZPLUtilities.replaceAllWithInternalDelimeter(var0).replace("^", ZPL_INTERNAL_FORMAT_PREFIX).replace("~", ZPL_INTERNAL_COMMAND_PREFIX);
    }

    public static String replaceInternalCharactersWithReadableCharacters(String var0) {
        return var0.replaceAll(ZPL_INTERNAL_COMMAND_PREFIX, "~").replaceAll(ZPL_INTERNAL_FORMAT_PREFIX, "^").replaceAll(ZPL_INTERNAL_DELIMITER, ",");
    }

    public static byte[] replaceInternalCharactersWithReadableCharacters(byte[] var0) {
        for (int var1 = 0; var1 < var0.length; ++var1) {
            if (var0[var1] == 16) {
                var0[var1] = 126;
                continue;
            }
            if (var0[var1] == 31) {
                var0[var1] = 44;
                continue;
            }
            if (var0[var1] != 30) continue;
            var0[var1] = 94;
        }
        return var0;
    }

    public static int getDpmm(String var0) {
        String[] var1 = var0.split(",");
        if (var1.length >= 3) {
            try {
                return Integer.parseInt(var1[2]);
            }
            catch (NumberFormatException var3) {
                return -1;
            }
        }
        return -1;
    }

    public static String[] filterFileList(String[] var0, String var1) {
        Pattern var2;
        Matcher var3;
        if (var1 == null || var1.equals("")) {
            var1 = "*:*.*";
        }
        if (!(var3 = (var2 = Pattern.compile("(([A-Za-z\\*]{1}):)?([A-Za-z0-9\\-_\\*]+)\\.([A-Za-z0-9\\-_\\*]+)")).matcher(var1)).matches()) {
            return new String[0];
        }
        Pattern var4 = Pattern.compile(ZPLUtilities.createFileNameRegex(var3));
        ArrayList<String> var5 = new ArrayList<String>();
        String[] var6 = var0;
        int var7 = var0.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            String var9 = var6[var8];
            Matcher var10 = var4.matcher(var9);
            if (!var10.matches()) continue;
            var5.add(var9);
        }
        return var5.toArray(new String[0]);
    }

    private static String createFileNameRegex(Matcher var0) {
        String var1 = "([A-Za-z]{1}:)?";
        String var2 = "[A-Za-z0-9\\-_]*";
        String var3 = var0.group(1);
        var3 = var3 == null ? var1 : var3.replaceAll("\\*:", var1);
        String var4 = var0.group(3).replaceAll("\\*", var2);
        String var5 = var0.group(4).replaceAll("\\*", var2);
        return var3 + var4 + "\\." + var5;
    }

    public static String getDYPrefix(char var0, String var1, char var2, String var3, int var4, String var5) {
        StringBuilder var6 = new StringBuilder();
        var6.append(ZPL_INTERNAL_COMMAND_PREFIX).append("DY").append(var0).append(':').append(var1).append(ZPL_INTERNAL_DELIMITER).append(var2);
        var6.append(ZPL_INTERNAL_DELIMITER).append(var3).append(ZPL_INTERNAL_DELIMITER).append(String.valueOf(var4)).append(ZPL_INTERNAL_DELIMITER).append(var5).append(ZPL_INTERNAL_DELIMITER);
        return var6.toString();
    }

    public static boolean isValidZplFirmware(String var0) {
        if (var0 == null) {
            return false;
        }
        Pattern var1 = Pattern.compile("[Vv][\\w-]+\\.[\\w-]+\\.[\\w-]+");
        Matcher var2 = var1.matcher(var0);
        return var2.matches();
    }

    private static class FileObjectDetails {
        public String access;
        public String storage;
        public long size;
        public long free;
    }

    class InternalCharacterFilteringOutputStream
    extends FilterOutputStream {
        public InternalCharacterFilteringOutputStream(OutputStream var2) {
            super(var2);
        }

        @Override
        public void write(int var1) throws IOException {
            if (var1 == 16) {
                var1 = 126;
            } else if (var1 == 31) {
                var1 = 44;
            } else if (var1 == 30) {
                var1 = 94;
            }
            super.write(var1);
        }
    }
}

